﻿//===============================================================
//【 ソフト名 】一括色置換スクリプトg_changer ver.1（２００６年７月２０日版）
//　　　　　　　一括色置換データ作成.js
//【 著作権者 】(c)2006 玉英・ZARASU.com
//【 Homepage 】http://www.zarasu.com/
//【  E-mail  】master@zarasu.com
//===============================================================
//設定
//色範囲選択時のlabカラー誤差の範囲
var Sa = 1;
//****************************************************************************

if (!app.documents.length) {    // 画像が開かれてない場合警告を出す
alert("画像が開いてません");
}else{
var OriginalUnit = preferences.rulerUnits;
preferences.rulerUnits = Units.PIXELS;
var docRef = app.activeDocument;


if(docRef.layers.length != 2){
alert("レイヤー枚数は必ず２枚でよろしく");
}else{
//画像を作業用に複製する
docRef = activeDocument.duplicate();

var a = new Array (2); 

//レイヤー名を変更
docRef.artLayers[0].name = "ato";
docRef.artLayers[1].name = "moto";

//atoレイヤーを「差の絶対値」に
docRef.artLayers.ato.blendMode = BlendMode.DIFFERENCE;

//黒色部分を選択
SelByColor("","","",1);

//atoレイヤーのモード戻す
docRef.artLayers.ato.blendMode = BlendMode.NORMAL;

//選択範囲内削除
docRef.activeLayer = docRef.artLayers.ato;
docRef.selection.clear();
docRef.activeLayer = docRef.artLayers.moto;
docRef.selection.clear();

//選択を解除
docRef.selection.deselect();


//ここから色の比較＆取得*********************************
var RGB_color = new Array (); 

while(1){
//ピクセルのある範囲を取得
deClear();

//不透明ピクセルがなくなったらループを抜ける
if(!x2){
	//ドキュメントを保存しないで閉じる
	activeDocument.close(SaveOptions.DONOTSAVECHANGES);
	break;
}

//切り抜き
activeDocument.crop([x1,y1,x2,y2]);

//画像を作業用に複製して縦１ピクセル切り抜く
docRef = activeDocument.duplicate();
activeDocument.crop([0,0,app.activeDocument.width,1]);

//ピクセルのある範囲（x1）を特定、色を取得
deClear();
var rgb0 = getPixel(x1,0)

//atoレイヤー削除、motoレイヤーの色を取得
docRef.artLayers.ato.remove();
var rgb1 = getPixel(x1,0)

RGB_color.push(rgb1[0],rgb1[1],rgb1[2]); //moto
RGB_color.push(rgb0[0],rgb0[1],rgb0[2]); //ato

//ドキュメントを保存しないで閉じる
activeDocument.close(SaveOptions.DONOTSAVECHANGES);
docRef = app.activeDocument;

//atoレイヤーのrgb値で範囲選択
colObj = new SolidColor();
colObj.rgb.red = rgb0[0];
colObj.rgb.green = rgb0[1];
colObj.rgb.blue = rgb0[2];
l = colObj.lab.l;
a = colObj.lab.a;
b = colObj.lab.b;
SelByColor(l,a,b);

//選択範囲内削除
docRef.activeLayer = docRef.artLayers.ato;
docRef.selection.clear();
docRef.activeLayer = docRef.artLayers.moto;
docRef.selection.clear();

//選択を解除
docRef.selection.deselect();
}
//ここまで***********************************************
var Text_doc = "";

//テキストに書き出すために整形する
for ( j=0 ; j<RGB_color.length ; j++ ){
var jflg = j + 1;
	if(jflg % 6){
	Text_doc = Text_doc + RGB_color[j] + "\t";
	}else{
	Text_doc = Text_doc + RGB_color[j] + "\n";
	}
}


filename = File.saveDialog("設定ファイル名を指定して保存します。");
if (filename)
{
fileObj = new File(filename);
flag = fileObj.open("w");
if (flag == true)
{
text = Text_doc;
fileObj.write(text);
fileObj.close();
}else{
alert("ファイルが開けませんでした");
}
}


filename = null;
fileObj = null;
docRef = null;
x1 = null;
y2 = null;
x2 = null;
y2 = null;

//定規の単位設定を元に戻す
app.preferences.rulerUnits = OriginalUnit;

alert("色情報を書き出しました。");
}
}


//色域選択
function SelByColor(color_L,color_A,color_B,hosoku)
{

if(hosoku){
//黒部分を選択
color_LAB = [0,0,0,0,0,0];
}else{
color_LAB = [color_L + Sa,color_A + Sa,color_B + Sa,color_L - Sa,color_A - Sa,color_B - Sa];
}
var com_SelByColor = charIDToTypeID( "ClrR" );
    var desc6 = new ActionDescriptor();
    var set_Band = charIDToTypeID( "Fzns" );
    desc6.putInteger( set_Band, 0 );
    var id28 = charIDToTypeID( "Mnm " );
        var desc7 = new ActionDescriptor();
        var id29 = charIDToTypeID( "Lmnc" );
        desc7.putDouble( id29, color_LAB[0] );
        var id30 = charIDToTypeID( "A   " );
        desc7.putDouble( id30, color_LAB[1] );
        var id31 = charIDToTypeID( "B   " );
        desc7.putDouble( id31, color_LAB[2] );
    var id32 = charIDToTypeID( "LbCl" );
    desc6.putObject( id28, id32, desc7 );
    var id33 = charIDToTypeID( "Mxm " );
        var desc8 = new ActionDescriptor();
        var id34 = charIDToTypeID( "Lmnc" );
        desc8.putDouble( id34, color_LAB[3] );
        var id35 = charIDToTypeID( "A   " );
        desc8.putDouble( id35, color_LAB[4] );
        var id36 = charIDToTypeID( "B   " );
        desc8.putDouble( id36, color_LAB[5] );
    var id37 = charIDToTypeID( "LbCl" );
    desc6.putObject( id33, id37, desc8 );
executeAction( com_SelByColor, desc6, DialogModes.NO );
}

//不透明ピクセルのある範囲を調べる
function deClear()
{
layObj = activeDocument.activeLayer.bounds;
x1 = parseInt(layObj[0]);
y1 = parseInt(layObj[1]);
x2 = parseInt(layObj[2]);
y2 = parseInt(layObj[3]);
}

//特定ピクセルの色の取得
function getPixel(x,y)
{
var R = G= B= 0,data;
var docObj = activeDocument;
var selReg = [[x,y],[x+1,y],[x+1,y+1],[x,y+1],[x,y]];
docObj.selection.select(selReg);
var data = docObj.channels[0].histogram;
for (var i=0; i<data.length; i++) if (data[i] > 0) { R = i; break; }
data = docObj.channels[1].histogram;
for (i=0; i<data.length; i++) if (data[i] > 0) { G = i; break; }
data = docObj.channels[2].histogram;
for (i=0; i<data.length; i++) if (data[i] > 0) { B = i; break; }
docObj.selection.deselect();
return [R,G,B];
}

